<?php
get_header();
/*
Template Name: Home
*/
?>


  <div id="cover" style="background-image: url(<?php echo esc_url( get_theme_mod( 'ma_image_de_fond_1' ) ); ?>);">
      <div class="background-mobile">
        <div class="overlay">
          <div class="container">
            <div class="row">
              <div class="col align-self-center">
                <h1 style="">Louer une <b>voiture&nbsp;de&nbsp;luxe</b><br>
                 <span class="titre-ville">à <b><?php echo get_theme_mod("villenamecourt", "Nom de la ville court"); ?></b><span>
                 </span></span>
                </h1>
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>voiture"><div class="button" style="">
                  Louer une voiture
                </div></a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>


    <section id="car-list-home">
      <div class="container">
        <div class="row">

<?php
// 1. on défini ce que l'on veut
$args = array(
    'post_type' => 'voiture',
    'posts_per_page' => 10,
    'order' => 'DESC',
);

// 2. on exécute la query
$my_query = new WP_Query($args);

// 3. on lance la boucle !
if($my_query->have_posts()) : while ($my_query->have_posts() ) : $my_query->the_post();
 ?>

        <div class="col-md-4">
           <a href="<?php the_permalink(); ?>">
            <div class="bloc-car-list-home">
               <?php $image = get_field('photo_classique'); ?>
              <img src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>">
              <h3><?php the_field('marque_de_la_voiture'); ?><br><span><?php the_title(); ?></span></h3>
              <p class="car-bloc-price">Réserver</p>
            </div>
          </a>
        </div>

 <?php

endwhile;
endif;

// 4. On réinitialise à la requête principale (important)
wp_reset_postdata();

 ?>

 <!------------------- bloc voiture bientot dispo -------------------->


 <!--------------------- bloc voiture bientot disp-------------------->

        </div>
        <div class="row">
          <div class="col-md-10 offset-md-1">
            <div class="bloc-text-list-car">
              <p>
                Vous souhaitez louer une voiture de luxe ? Que ce soit pour un plaisir personnel, un événement particulier ou un déplacement professionnel, <?php echo get_theme_mod("nomsociete", "Nom de la societe"); ?> met à disposition sa flotte de véhicules prestigieux et son service de qualité pour sublimer votre moment.
              </p>
            </div>
          </div>
        </div>
      </div>
    </section>





    <section id="bloc-info" style="background-image: url(<?php echo esc_url( get_theme_mod( 'ma_image_de_fond_2' ) ); ?>);">
      <div class="container">
        <div class="row justify-content-end">
          <div class="col-lg-5">
            <h2 style="color: white; text-transform: uppercase;">LOCATIONS DE VOITURES DE&nbsp;LUXE <?php echo get_theme_mod("villenamelong", "Nom de la ville long"); ?></h2>
            <p><?php echo get_theme_mod("nomsociete", "Nom de la societe"); ?> <?php echo get_theme_mod("villenamelong", "Nom de la ville long"); ?> est une agence spécialisée dans la location de voiture de luxe sur la ville de <?php echo get_theme_mod("villenamecourt", "Nom de la ville court"); ?> et ses alentours.
Passionné par l’univers des voitures de sport depuis toujours, j’ai décidé d’en faire mon métier.
<?php echo get_theme_mod("nomsociete", "Nom de la societe"); ?> répond à toutes vos demandes et vous propose divers véhicules haut de gamme pour vos déplacements privés et professionnels.
Louer une voiture de luxe devient accessible, les marques de voiture les plus prestigieuses sont disponibles à la location pour votre plus grand plaisir.
<?php echo get_theme_mod("nomsociete", "Nom de la societe"); ?> met à disposition de sa clientèle des véhicules prestigieux de grandes marques sur la ville de <?php echo get_theme_mod("villenamecourt", "Nom de la ville court"); ?> et ses alentours. Nous assurons une qualité de service qui saura faire de votre location un moment d’évasion et de pur plaisir à bord de votre voiture de luxe.
</p>
            <a href="<?php echo esc_url( home_url( '/' ) ); ?>voiture/"><div class="button" style="margin: 30px auto;">
              Louer une voiture
            </div></a>
          </div>
        </div>
      </div>
    </section>







    <div id="cta-footer">
      <div class="container-fluid">
        <div class="row">
          <div class="col">
            <h3>Je reserve une <b>voiture de luxe !</b></h3>

              <a href="<?php echo esc_url( home_url( '/' ) ); ?>contact" class="btn-cta-footer"><div class="button" style="margin: 30px auto 0;">
                Nous Contacter
              </div></a>
          </div>
        </div>
      </div>
    </div>



    <?php
    get_footer();
